#############################################################################
# MUDA: Resurrection							    #
# Ms_SysCmds.pm		: System commands.
# Artist:		: Theodore J. Soldatos				    #
#############################################################################
# This file is part of MUDA:Resurrection.			   	    #
#									    #
# MUDA:Resurrection is free software: you can redistribute it and/or modify #
# it under the terms of the GNU General Public License as published by	    #
# the Free Software Foundation, either version 3 of the License, or	    #
# (at your option) any later version.					    #
#									    #
# MUDA:Resurrection is distributed in the hope that it will be useful,	    #
# but WITHOUT ANY WARRANTY; without even the implied warranty of	    #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the		    #
# GNU General Public License for more details.				    #
#									    #
# You should have received a copy of the GNU General Public License	    #
# along with MUDA:Resurrection.  If not, see <http://www.gnu.org/licenses/>.#
#									    #
# Copyright 2012 Theodore J. Soldatos					    #
#############################################################################


package Ms_Libs;

use strict;
use warnings;

use IPC::SysV qw(IPC_PRIVATE IPC_RMID IPC_CREAT S_IRWXU IPC_NOWAIT);
use Text::Autoformat;

BEGIN {
use Exporter ();
our ($VERSION, @ISA, @EXPORT, @EXPORT_OK, %EXPORT_TAGS);
# set the version for version checking
$VERSION = 1.00;
@ISA = qw(Exporter);
@EXPORT = qw(&sysCmdDumpData &sysCmdShutdown &sysCmdReload &sysCmdDebug &sysCmdCreateUser &sysCmdReboot);
%EXPORT_TAGS = ( ); # eg: TAG => [ qw!name1 name2! ],
#@EXPORT_OK = qw();
}
our @EXPORT_OK;

sub sysCmdDumpData {
	# A debug routine. Dumps various data structures and exits.
	my ($pid, $args) = @_;
	my ($username, $uid, $cmqid, $roomNum, $gender) = &intPid2Details($pid);
	my $msg;
	# All user data:
	&clientTell($cmqid, $username, $pid, "===============> DATA DUMP\n");
	foreach my $user_ref (@main::usersMainData) {
		if (not defined ($user_ref->{username})) {next;};
		$msg =  "User: $user_ref->{username}\n";
		&clientTell($cmqid, $username, $pid, $msg);
		while (my ($key, $value) = each %$user_ref) {
			$msg =  "\t|$key| is |$value|\n";
			&clientTell($cmqid, $username, $pid, $msg);
		};
	};
	# Hash of hashes:
	while (my ($key, $value) = each %$main::userPass_ref) {
		$msg =  "User $key:\n"; 
		&clientTell($cmqid, $username, $pid, $msg);
		while (my ($key2, $value2) = each %$value) {
			$msg =  "\t|$key2| is |$value2|\n";
			&clientTell($cmqid, $username, $pid, $msg);
		};
	};
	# Hash of hashes:
	while (my ($key, $value) = each %main::itemData) {
		$msg =  "Item $key:\n"; 
		&clientTell($cmqid, $username, $pid, $msg);
		while (my ($key2, $value2) = each %$value) {
			$msg =  "\t|$key2| is |$value2|\n";
			&clientTell($cmqid, $username, $pid, $msg);
		};
	};
	$msg =  "Logged in users:";
	&clientTell($cmqid, $username, $pid, $msg);
	foreach my $username (@main::loggedInUsers) { 
		$msg =  " $username";
		&clientTell($cmqid, $username, $pid, $msg);
	};
	$msg =  "\n";
	&clientTell($cmqid, $username, $pid, $msg);
	my $uprk = %$main::userPass_ref;
	$msg =  "userPass_ref keys #: $uprk\n";
	&clientTell($cmqid, $username, $pid, $msg);
	$msg =  "===============> DATA DUMP END\n";
	&clientTell($cmqid, $username, $pid, $msg);
};

sub sysCmdReboot {
	&sysCmdShutdown('1');
};

sub sysCmdShutdown {
	my ($rebflg, undef) = @_;
	# Cleanup, inform users etc and exit. 
	if ($rebflg eq '1') {
		&tellAllUsers("Restarting MUDA server.\n");
		&logPrint("Restarting MUDA server.\n");
	} else {
		&tellAllUsers("Shutting down MUDA server.\n");
		&logPrint("Shutting down MUDA server.\n");
	};
	# Save all users:
	&saveAllUsers;
	# Save all items:
	&saveAllItems;
	# Mass save of user/quest data.
	&saveAllUsersQuests;
	# Save all quests:
	&saveAllQuests;
	# Special command message:
	foreach my $username (@main::loggedInUsers) {
		# Server command to client. pid included to avoid accidents.
		my $msg = "SCMD2CLNT $main::usersMainData[ $main::userPass_ref->{$username}->{uid} ]->{ pid } EXIT"; 
		my $mqmsg = pack("l! a*", 1, $msg);
		my $cmqid = $main::usersMainData[ $main::userPass_ref->{$username}->{uid} ]->{ qid };
		my $c_pid = $main::usersMainData[ $main::userPass_ref->{$username}->{uid} ]->{ pid };
		if (not(msgsnd($cmqid, $mqmsg, IPC_NOWAIT))) {
			&logPrint("Error trying to send logout system message to $username ($cmqid)\n");
		};
		$main::killrsp = kill('USR1', $c_pid);
		if (not ($main::killrsp)) {
			&logPrint("Error trying to SIGUSR1 $username ($c_pid)\n");
		};
	};
			#&clientTell($main::usersMainData[ $main::userPass_ref->{$username}->{uid} ]->{ qid }, $username, $main::usersMainData[ $main::userPass_ref->{$username}->{uid} ]->{ pid }, $msg);
	msgctl($main::mmqid, IPC_RMID,0);
	# Remove pid file:
	&logPrint( "Removing lockfile.\n" );
	unlink $main::pidfile;
	if ($rebflg eq '1') {
		use Cwd;
		my $cwd = cwd();
		exec ("$cwd/$main::mudacmd");
		exit;
	} else {
		exit;
	};
};

sub sysCmdReload {
	my ($pid, $subCmd, undef) = @_;
	my ($username, $uid, $cmqid, $roomNum, $gender) = &intPid2Details($pid);
	my $hlpmsg = "Available subCMDs: LIB, ILOOP, NPCLOOP, ICODE, NPCCODE, ALL.\n";
	$subCmd = uc($subCmd);
	if (
		(not defined $subCmd) or 
		($subCmd eq '')  
		) {
			&clientTell($cmqid, $username, $pid, $hlpmsg);
			return;
		};
	if (
		($subCmd eq 'LIB') or
		($subCmd eq 'ALL') 
	) { 
		&tellAllUsers("Abouda exec kthulhu load!\n");
		&tellAllUsers("Don\'t be affraid, I\'m just reloading the source :-)\n");
		use Module::Reload::Selective;
		$Module::Reload::Selective::Options->{SearchProgramDir} = 1;
		$Module::Reload::Selective::Options->{ReloadOnlyIfEnvVarsSet} = 0;
		$Module::Reload::Selective::Options->{DontReloadIfPathContains} = ['lib/perl', 'share/perl', 'share/perl5'];
    		eval { Module::Reload::Selective->reload(qw(Ms_Libs)); };
		if ($@) {
			&logPrint( "Reload: $@\n" );
			&tellAllUsers("Ooops! Reload failed!\n");
			&tellAllUsers("Reality collapses around us  in data files and execs...\n");
			&tellAllUsers("We  are trapped in a data file...and freezed to survive...\n");
			&tellAllUsers("In other words, program stops...\n");
			&sysCmdShutdown;
			return;
		};
    		Ms_Libs->import;
		#print "Import: $@" if $@;
		&clientTell($cmqid, $username, $pid, "Library reloaded successfully!\n");
		if ($subCmd eq 'ALL') {
			&reloadItemLoopCode($pid);
			&reloadItemCode($pid);
			&reloadNpcLoopCode($pid);
			&reloadNpcCode($pid);
		};
		return;
	} elsif ($subCmd eq 'ILOOP') {
		&reloadItemLoopCode($pid);
	} elsif ($subCmd eq 'ICODE') {
		&reloadItemCode($pid);
	} elsif ($subCmd eq 'NPCLOOP') {
		&reloadNpcLoopCode($pid);
	} elsif ($subCmd eq 'NPCCODE') {
		&reloadNpcCode($pid);
	} else {
		&clientTell($cmqid, $username, $pid, $hlpmsg);
		return;
	};
};

sub sysCmdDebug {
	# Call debug stuff. Output can go to stdout of server or user.
	my ($pid, $subCmd, undef) = @_;
	my ($username, $uid, $cmqid, $roomNum, $gender) = &intPid2Details($pid);
	my $hlpmsg = "Available subCMDs: NOTIF, LISTUSERS, LISTFIGHTS, DUMPUSERS, SHOWUSER <uid>, LISTITEMS, SHOWITEM <itemid>.\n";
	($subCmd, my $args) = split / /, $subCmd;
	if (
		(not defined $subCmd) or 
		($subCmd eq '')  
		) {
			&clientTell($cmqid, $username, $pid, $hlpmsg);
			return;
		};
	$subCmd = uc($subCmd);
	if ($subCmd eq 'NOTIF') {
		# Show notifiers:
		my @notifiers = $main::loop->notifiers;
		foreach my $notif (@notifiers) {
			&clientTell($cmqid, $username, $pid, $notif->notifier_name . "\n");
		};
	} elsif ($subCmd eq 'LISTUSERS') {
		# List uids and usernames:
		foreach my $luid (keys @main::usersMainData) {
			if (defined $main::usersMainData[ $luid ] ) {
				my $msg = "User: " . $main::usersMainData[ $luid ]->{ username } . "($luid) : ";
				$msg .= " User" if $main::usersMainData[ $luid ]->{ pid } != -2;
				$msg .= " (LoggedIn)" if $main::usersMainData[ $luid ]->{ pid } > 0;
				$msg .= " NPC" if $main::usersMainData[ $luid ]->{ pid } == -2;
				$msg .= "\n";
				&clientTell($cmqid, $username, $pid, $msg);
			};
		};
	} elsif ($subCmd eq 'LISTFIGHTS') {
		# List uids and usernames:
		foreach my $fight (keys %main::fightData) {
			my $msg = "Fight: $fight ";
			if (defined $main::fightData{$fight}->{ valid} ) {
				$msg .= " valid: " . $main::fightData{$fight}->{ valid };
			} else {
				$msg .= " valid: UNDEF";
			};
			if (defined $main::fightData{$fight}->{ attUid }) {
				$msg .= " AttUid: " . $main::fightData{$fight}->{ attUid };
			} else {
				$msg .= " AttUid UNDEF";
			};
			if (defined $main::fightData{$fight}->{ defUid }) {
				$msg .= " defUid: " . $main::fightData{$fight}->{ defUid };
			} else {
				$msg .= " defUid UNDEF";
			};
			if (defined $main::fightData{$fight}->{ timeOut }) {
				$msg .= " timeOut: " . $main::fightData{$fight}->{ timeOut };
			} else {
				$msg .= " timeOut UNDEF";
			};
			if (defined $main::fightData{$fight}->{ timeCnt }) {
				$msg .= " timeCnt: " . $main::fightData{$fight}->{ timeCnt };
			} else {
				$msg .= " timeCnt UNDEF";
			};
			$msg .= "\n";
			&clientTell($cmqid, $username, $pid, $msg);
		};
	} elsif ($subCmd eq 'SHOWUSER') {
		use Data::Dumper;
		&clientTell($cmqid, $username, $pid, "Dumped in logs.\n");
		print Dumper($main::usersMainData[$args]);
	} elsif ($subCmd eq 'DUMPUSERS') {
		use Data::Dumper;
		&clientTell($cmqid, $username, $pid, "Dumped in logs.\n");
		print Dumper(@main::usersMainData);
	} elsif ($subCmd eq 'SHOWITEM') {
		use Data::Dumper;
		&clientTell($cmqid, $username, $pid, "Dumped in logs.\n");
		print "---------> Main item structure:\n";
		print Dumper($main::itemData{ $args });
		print "---------> Main item structure END\n";
		print "---------> User inventory structure:\n";
		print Dumper($main::usersMainData[ $uid ]->{ inventory }->{ $args });
		print "---------> User inventory structure END\n";
	} elsif ($subCmd eq 'LISTITEMS') {
		foreach my $iid (keys %main::itemData) {
			&clientTell($cmqid, $username, $pid, "#$iid: $main::itemData{$iid}->{ shortDesc }\n");
		};
	} else {
		&clientTell($cmqid, $username, $pid, $hlpmsg);
		return;
	};

};

sub sysCmdCreateUser {
	# Args: pid of summoner (0 for auto)
	#	new user's username
	# 	new user's password
	my ($pid, $args, undef) = @_;
	my ($newUsername, $newPassword) = split / /, $args, 2;
	my ($username, $uid, $cmqid, $roomNum, $gender);
	if ($pid > 0) {
		($username, $uid, $cmqid, $roomNum, $gender) = &intPid2Details($pid);
	};
	if (
		(not defined $newUsername) or
		(not defined $newPassword) or
		($newPassword eq '') or
		($newUsername eq '') 
	) { 
		&logPrint("Failed sysCmdCreateUser: missing parameters ($newUsername)($newPassword)\n");
		&clientTell($cmqid, $username, $pid, "Missing parameters!\n")
			if $pid > 0;
		return 0;
	};
	# Check username uniqueness:
	foreach my $ouid (keys @main::usersMainData) {
		if (not defined $main::usersMainData[$ouid]->{ username }) { next; };
		if (lc($newUsername) eq lc($main::usersMainData[$ouid]->{ username })) {
			&logPrint("Failed sysCmdCreateUser: username exists\n");
			&clientTell($cmqid, $username, $pid, "User $newUsername already exists!\n")
				if $pid > 0;
			return 0;
		};
	};
	if ($main::userLock == 1) { 
		&logPrint("Failed sysCmdCreateUser: lock\n");
		&clientTell($cmqid, $username, $pid, "user creation lock!\n")
			if $pid > 0;
		return 0; 
	};
	$main::userLock = 1;
	# Create record:
	my $newUserRec = {	username 	=> $newUsername,
				password 	=> $newPassword,
				desc	 	=> 'A MUDA citizen.',
				level	 	=> 1,
				coins	 	=> 5000,
				xp	 	=> 0,
				room	 	=> 1,
				pid	 	=> -1,		# Not logged in.
				qid	 	=> -1,		# Not logged in.
				timeout	 	=> 0,		# Inactivity counter.
				validCode	=> 0,		# If coded NPC, becomes 1 when code is 
								# successfully parsed.
				godMode	 	=> 0,
				email	 	=> 'Not defined.',
				gender	 	=> 2,
				paralyzed 	=> 0,
				invisible 	=> 0,
				invincible 	=> 0,		# No fights possible at all.
				blind	 	=> 0,
				hitPoints 	=> 100,
				mana	 	=> 100,
				maxHp 		=> 100,
				maxMana	 	=> 100,
				lastCon	 	=> 'Never.',
				lastDiscon	=> 'Never.',
				lastSave	=> 'Never.',		
				inventory	=> {},		# User's inventory
				npc		=> 0,		# If true, is NPC
				npc_code_ref	=> '',		# NPC main sub ref
				npc_loop_ref	=> '',		# NPC loop sub ref
				npc_loop_secs	=> 0,		# Period of NPC loop
				npc_code	=> '',		# NPC code filename
				protoId		=> 0,		# NPC prototype ID 
				revivalTime	=> 0,		# NPC revival time
				quests		=> {},		# Completed quests
				poisoned	=> 0,		# 
				intoxicated	=> 0,		# 
				fuel		=> 100,		# 
				alignement	=> 0,		# 
			};

	# Define new user id:
	my $nuid = $main::maxUserId + 1;
	# Do a redundant check of existance:
	if (defined $main::usersMainData[ $nuid ]) {
		# Somehow it exists. Increase $maxUserId and return fail.
		&logPrint("Failed sysCmdCreateUser: exists\n");
		&clientTell($cmqid, $username, $pid, "user uid conflict: $nuid\n")
			if $pid > 0;
		$main::maxUserId++;
		$main::userLock = 0;
		return 0;
	};
	$main::usersMainData[ $nuid ] = $newUserRec;
	# Add it in the room:
	push @{ $main::roomsData[ $newUserRec->{ room } ]->{presentUids} }, $nuid;
	push @{ $main::roomsData[ $newUserRec->{ room } ]->{presentUsers} }, $newUserRec->{ username };
	# Also update userPass hash: 
	$main::userPass_ref->{ $newUserRec->{ username } } = {	password	=>	$newPassword,
					  			uid		=>	$nuid
							};
	$main::maxUserId = $nuid;

	&clientTell($cmqid, $username, $pid, "Created $newUsername with uid $nuid\n")
		if $pid > 0;
	# Save new user:
	&saveNewUser($nuid);
	$main::userLock = 0;
	return $nuid;
};


END { } # module clean-up code here (global destructor)

1; # don't forget to return a true value from the file
