#!/usr/bin/perl

use Term::ReadLine;
#use strict;

my $roomsDataPath = './ROOMS.DAT';
my $roomsLongPath = './ROOMS.LOD';
my $roomsShortPath = './ROOMS.SHD';
my $cntr = 0;
my $termWidth = 48;	# Terminal width! :-)

my $pos = 1;	# "User" position.

my %dirLtS = ( 	EAST		=>	'E',
		WEST		=>	'W',
		SOUTH		=>	'S',
		NORTH		=>	'N',
		UP		=>	'U',
		DOWN		=>	'D',
		SOUTHEAST	=>	'SE',
		SOUTHWEST	=>	'SW',
		NORTHEAST	=>	'NE',
		NORTHWEST	=>	'NW'
	);
my %commands = (	GO		=>	'cmdGo',
			LOOK		=>	'printRoom',
			E		=>	'cmdGo E',
			W		=>	'cmdGo W',
			S		=>	'cmdGo S',
			N		=>	'cmdGo N',
			U		=>	'cmdGo U',
			D		=>	'cmdGo D',
			SE		=>	'cmdGo SE',
			SW		=>	'cmdGo SW',
			NE		=>	'cmdGo NE',
			NW		=>	'cmdGo NW'
		);

my @directions = ('E', 'W', 'N', 'S', 'U', 'D', 'SE', 'SW', 'NE', 'NW');

# Data structures:

my @roomsLongDescr = my @roomsShortDescr = (); # Descriptions.

my @roomsData = ();	# Rooms data. An array of hashes.

my $term = new Term::ReadLine 'MUDA';
my $prompt = ">";

my $cmdArgs;

# Load rooms data:

# First long descriptions:
print "Loading long descriptions... ";
open(RDATA, "<", $roomsLongPath)
    or die "cannot open < $roomsLongPath: $!";
while (my $line = <RDATA>) {
	my ($dump, $num, $text) = split(/\$/, $line, 3);
	$roomsLongDescr[$num] = $text;
	$cntr++;
};
close RDATA;
print "$cntr loaded.\n";

# Short descriptions:
$cntr = 0; 	# Important, we are based on line num.
print "Loading short descriptions... ";
open(RDATA, "<", $roomsShortPath)
    or die "cannot open < $roomsShortPath: $!";
SHORT: while (my $line = <RDATA>) {
	chomp($line);
#	if ($cntr == 984) {
#		print "\n|$line|\n";
#	};
#	print "EMPTY!" if ($line eq '');
	next SHORT if $line eq '';	# Discard empty lines.
	$cntr++;
	$roomsShortDescr[$cntr] = $line;
};
close RDATA;
print "$cntr loaded.\n";

# Room data:
print "Loading room data... ";
open(RDATA, "<", $roomsDataPath)
    or die "cannot open < $roomsDataPath: $!";
$cntr=0;
RDAT: while (my $line = <RDATA>) {
	my ($RoomNum, $ShDesPos, $LoDesPos, $exE, $exW, $exN, $exS, $exU, $exD, $exNE, $exNW, $exSE, $exSW) = split(/\t/, $line, 13);
	if (($ShDesPos == 0) and ($LoDesPos == 0)) {
		next RDAT; 	# Deleted room.
	};
	my %tmpRoom = (
		shDesPos 	=>	$ShDesPos,
		loDesPos 	=>	$LoDesPos,
		exE 		=>	$exE,
		exW 		=>	$exW,
		exN 		=>	$exN,
		exS 		=>	$exS,
		exU 		=>	$exU,
		exD 		=>	$exD,
		exNE 		=>	$exNE,
		exNW 		=>	$exNW,
		exSE 		=>	$exSE,
		exSW 		=>	$exSW
	);
	$roomsData[$RoomNum] = \%tmpRoom;
	$cntr++;
};
close RDATA;
print "$cntr loaded.\n";

printRoom($pos);

my $OUT = $term->OUT || \*STDOUT;
  while ( defined ($_ = $term->readline($prompt)) ) {
	#Trim white space:
	$_ =~ s/^\s*(.*?)\s*$/$1/;
	my ($cmd, $args) = split(/ /, uc($_), 2);	
	$cmd =~ s/^\s*(.*?)\s*$/$1/;
	$args =~ s/^\s*(.*?)\s*$/$1/;
	if ($commands{ $cmd } eq '') {
		print "Unknown command.\n";
	} else {
		my ($execmd, $biArgs) = split(/ /, $commands{ $cmd }, 2);
		my @args;
		if ($biArgs ne '') {push(@args, $biArgs)};
		if ($args ne '') {push(@args, $args)};
		push(@args, $pos);
			
		#print "DEBUG: |$execmd|\n";
		#print "DEBUG: |@args|\n";
		$pos = &{ $execmd }( @args );
	};
	
    	$term->addhistory($_) if /\S/;
  }

exit;

sub cmdGo {
	# Move to direction:
	#print "DEBUG: args is |@_|\n";
	#my ($dir, $oldpos, $rest) = split(/ /, $cmdArgs, 3);
	my ($dir, $oldpos, $rest) = @_;
	$dir = uc($dir);
	#print "DEBUG: dir=|$dir|\n";
	#print "DEBUG: longdir=|$longdir|\n";
	if (grep($dir, @directions) == 0) {
		# Not found as short, try long:
		$dir = $dirLtS{$dir};
	};
	if (grep($dir, @directions) == 0) {
		# Again not found, return.
		print "Go where ?\n";
		return $oldpos;
	};
	my $dirSTR = "ex$dir";
	my $newpos = $roomsData[$pos]{ $dirSTR };
	if ($newpos eq '') {
		print "Go where ?\n";
		return $oldpos;
	};
	if ($newpos == 0) {
		print "Boing!\n";
		return $oldpos;
	};
	printRoom($newpos);
	return $newpos; 
};

sub printRoom {
	# Print current room:
	my ($pos, $rest) = @_;

	#print "DEBUG: pos is |$pos|\n";
	print "Room #$pos\n\n";
	printLong("$roomsLongDescr[$pos]");

	print "Exits:\n";

	print "East:\t$roomsShortDescr[ $roomsData[$pos]{exE} ]\n" if ($roomsData[$pos]{exE} != 0);
	print "West:\t$roomsShortDescr[ $roomsData[$pos]{exW} ]\n" if ($roomsData[$pos]{exW} != 0);
	print "North:\t$roomsShortDescr[ $roomsData[$pos]{exN} ]\n" if ($roomsData[$pos]{exN} != 0);
	print "South:\t$roomsShortDescr[ $roomsData[$pos]{exS} ]\n" if ($roomsData[$pos]{exS} != 0);
	print "Up:\t$roomsShortDescr[ $roomsData[$pos]{exU} ]\n" if ($roomsData[$pos]{exU} != 0);
	print "Down:\t$roomsShortDescr[ $roomsData[$pos]{exD} ]\n" if ($roomsData[$pos]{exD} != 0);
	print "NE:\t$roomsShortDescr[ $roomsData[$pos]{exNE} ]\n" if ($roomsData[$pos]{exNE} != 0);
	print "NW:\t$roomsShortDescr[ $roomsData[$pos]{exNW} ]\n" if ($roomsData[$pos]{exNW} != 0);
	print "SE:\t$roomsShortDescr[ $roomsData[$pos]{exSE} ]\n" if ($roomsData[$pos]{exSE} != 0);
	print "SW:\t$roomsShortDescr[ $roomsData[$pos]{exSW} ]\n" if ($roomsData[$pos]{exSW} != 0);
	return $pos;

};

sub printLong {
	my ($line, $rest) = @_;
	while ($line ne '') {
		print substr($line, 0, $termWidth), "\n";
		$line = substr($line, $termWidth);
	};
};

